<table class="w-full min-w-full text-center mt-6">
    <thead class="bg-gray-50 dark:bg-gray-900/50">
        <tr>
            <th class="border border-gray-200 px-4 py-2">Date</th>
            <th class="border border-gray-200 px-4 py-2">Method</th>
            <th class="border border-gray-200 px-4 py-2">Amount (KES)</th>
            <th class="border border-gray-200 px-4 py-2">Payable Type</th>
            <th class="border border-gray-200 px-4 py-2">Reference</th>
        </tr>
    </thead>

    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
        @php $payment = $payment ?? ($payments ?? null); @endphp
        @if ($payment)
            <tr>
                <td class="border border-gray-200 px-4 py-2">{{ $payment->created_at->format('d M Y') }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ ucfirst($payment->payment_method) }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ number_format($payment->amount_paid, 2) }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ class_basename($payment->payable_type) }}</td>
                <td class="border border-gray-200 px-4 py-2">
                    @if ($payment->payable_type === \App\Models\Conveyancing::class)
                        {{ $payment->payable?->serial_number ?? 'N/A' }}
                    @elseif ($payment->payable_type === \App\Models\Litigation::class)
                        {{ $payment->payable?->case_number ?? 'N/A' }}
                    @elseif ($payment->payable_type === \App\Models\Project::class)
                        {{ $payment->payable?->name ?? 'N/A' }}    
                    @else
                        {{ $payment->payable_id ?? 'N/A' }}
                    @endif
                </td>
            </tr>
        @else
            <tr>
                <td colspan="7" class="text-center py-4 text-gray-500">No payment data found.</td>
            </tr>
        @endif
    </tbody>
</table>
