@php
    $totalPaid = $payments->sum('amount_paid');
    $balanceTotal = $payments->sum('balance');
@endphp

<div class="overflow-x-auto">
<table class="w-full min-w-full text-center">
    <thead class="bg-gray-50 dark:bg-gray-900/50">
        <tr>
            <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 tracking-wide uppercase">
                Date Paid
            </th>
            <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 tracking-wide uppercase">
                Payment Method
            </th>
            <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 tracking-wide uppercase">
                Transaction ID
            </th>
            <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 tracking-wide uppercase">
                Status
            </th>
            <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 tracking-wide uppercase">
                Amount Paid
            </th>
        </tr>
    </thead>
    <tbody>
        @forelse ($payments as $payment)
            <tr>
                <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300">
                    {{ \Carbon\Carbon::parse($payment->created_at)->format('M d, Y') }}
                </td>
                <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300">
                    {{ $payment->payment_method ?? 'N/A' }}
                </td>
                <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300">
                    {{ $payment->transaction_id ?? 'N/A' }}
                </td>
                <td class="border border-gray-200 px-4 py-2">
                    @php
                        $status = strtolower($payment->status);
                        $badgeColors = [
                            'pending' => 'warning',
                            'appealed' => 'info',
                            'open' => 'secondary',
                            'closed' => 'danger',
                            'completed' => 'success',
                        ];
                        $badgeColor = $badgeColors[$status] ?? 'gray';
                    @endphp
                    <x-filament::badge :color="$badgeColor">
                        {{ ucwords(str_replace('_', ' ', $payment->status)) }}
                    </x-filament::badge>
                </td>
                <td class="border border-gray-200 px-4 py-2 text-gray-900 dark:text-gray-100 font-medium">
                    {{ number_format($payment->amount_paid, 2) }}
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="5"
                    class="border border-gray-200 px-4 py-2 text-center text-gray-500 dark:text-gray-400 text-base">
                    No payments found.
                </td>
            </tr>
        @endforelse

        @if ($payments->count())
            <tr class="bg-gray-100 dark:bg-gray-800 font-semibold">
                <td colspan="4" class="border border-gray-300 px-4 py-2 text-right text-gray-700 dark:text-gray-200">
                    Total Amount:
                </td>
                <td class="border border-gray-300 px-4 py-2 text-gray-900 dark:text-gray-100">
                    {{ number_format($totalPaid, 2) }}
                </td>
            </tr>
        @endif
    </tbody>
</table>
</div>
