@php
    function getIconPath($filePath)
    {
        $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
        return match ($extension) {
            'pdf' => 'images/pdf-icon.png',
            'doc', 'docx' => 'images/word-icon.png',
            'xls', 'xlsx' => 'images/excel-icon.png',
            'jpg', 'jpeg', 'png', 'gif' => 'storage/' . $filePath,
            default => 'images/file-icon.png',
        };
    }
@endphp

@if (!empty($case_number))
    <div class="mb-4 text-justify">
        <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
            System Generated Case Number: <span class="text-primary-600 dark:text-primary-400">{{ $case_number }}</span>
        </h2>
        <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
            Court Assigned Case Number: <span
                class="text-primary-600 dark:text-primary-400">{{ $court_assigned_case_number }}</span>
        </h2>
        <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
            Case Citation: <span class="text-primary-600 dark:text-primary-400">{{ strtoupper($description) }}</span>
        </h2>
        
    </div>
@endif

<div class="overflow-x-auto">
    <table class="w-full min-w-full text-center">
        <thead class="bg-gray-50 dark:bg-gray-900/50">
            <tr>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Court</th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Case Type</th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Case Category
                </th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Description</th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Amount Charged</th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Documents</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-300">{{ $court ?? 'N/A' }}</td>
                <td class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-300">{{ $type ?? 'N/A' }}</td>
                <td class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-300">
                    {{ $case_category ?? 'N/A' }}</td>
                <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300 italic">
                    {{ $description ?? 'N/A' }}
                </td>
                <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300 ">
                    {{ number_format($amount_charged,2) ?? 'N/A' }}
                </td>
                <td class="border border-gray-200 px-4 py-2">
                        @if ($documents && $documents->isNotEmpty())
                            <div class="grid grid-cols-2 gap-3 ">
                                @foreach ($documents as $document)
                                    @php
                                        $extension = strtolower(pathinfo($document->file_path, PATHINFO_EXTENSION));

                                        $iconMap = [
                                            'pdf' => 'pdf-icon.png',
                                            'doc' => 'word-icon.png',
                                            'docx' => 'word-icon.png',
                                            'xls' => 'excel-icon.png',
                                            'xlsx' => 'excel-icon.png',
                                            'jpg' => 'image-icon.png',
                                            'jpeg' => 'image-icon.png',
                                            'png' => 'image-icon.png',
                                            'txt' => 'text-icon.png',
                                        ];

                                        $icon = $iconMap[$extension] ?? 'file-icon.png';
                                    @endphp

                                    <div class="flex flex-col items-center text-center">
                                        <a href="{{ asset('storage/' . $document->file_path) }}" target="_blank"
                                            class="flex justify-center">
                                            <img src="{{ asset('images/' . $icon) }}" alt="{{ strtoupper($extension) }}"
                                                class="h-6 w-6 object-contain hover:scale-110 transition">
                                        </a>
                                        <p class="mt-1 text-xs text-gray-700 dark:text-gray-300 truncate w-full">
                                            {{ $document->name }}
                                        </p>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <span class="text-gray-500 dark:text-gray-400 italic">N/A</span>
                        @endif
                </td>
            </tr>
        </tbody>
    </table>
</div>