@if ($parties && $parties->count())
<div class="overflow-x-auto">
    <table class="w-full min-w-full text-center border border-gray-200 dark:border-gray-700">
        <thead class="bg-gray-50 dark:bg-gray-900/50">
            <tr>
                <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">#</th>
                <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">Party</th>
                <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">Party Type</th>
                <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">Email</th>
                <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">Phone</th>
            </tr>
        </thead>
        <tbody class="bg-white dark:bg-gray-950">
            @foreach ($parties as $index => $party)
                <tr class="border-t border-gray-200 dark:border-gray-700">
                    <td class="border px-4 py-2 text-gray-900 dark:text-gray-100 font-medium">
                        {{ $index + 1 }}
                    </td>
                    <td class="border px-4 py-2 text-gray-800 dark:text-gray-100">
                        {{ $party->party ?? 'N/A' }}
                    </td>
                    <td class="border px-4 py-2 text-gray-600 dark:text-gray-300">
                        {{ $party->party_type ?? 'N/A' }}
                    </td>
                    <td class="border px-4 py-2 text-gray-600 dark:text-gray-300">
                        {{ $party->email ?? 'N/A' }}
                    </td>
                    <td class="border px-4 py-2 text-gray-600 dark:text-gray-300">
                        {{ $party->phone ?? 'N/A' }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>    
@else
    <p class="text-gray-500 dark:text-gray-400 italic">No party details available for this litigation.</p>
@endif
