<div class="overflow-x-auto">
<table class="w-full min-w-full text-center border border-gray-200 dark:border-gray-700">
    <thead class="bg-gray-50 dark:bg-gray-900/50">
        <tr>
            <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">#</th>
            <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">Activity</th>
            <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">Date</th>
            <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">Court Room</th>
            <th class="border px-4 py-2 font-bold text-gray-700 dark:text-gray-200 uppercase">Outcome</th>
        </tr>
    </thead>
    <tbody class="bg-white dark:bg-gray-950">
        @forelse ($activities as $index => $activity)
            <tr>
                <td class="border px-4 py-2 text-gray-900 dark:text-gray-100 font-medium">
                    {{ $index + 1 }}
                </td>
                <td class="border px-4 py-2 text-gray-800 dark:text-gray-100">
                    {{ $activity->activity ?? 'N/A' }}
                </td>
                <td class="border px-4 py-2 text-gray-600 dark:text-gray-300">
                    {{ $activity->activity_date ? \Carbon\Carbon::parse($activity->activity_date)->format('d M Y') : '-' }}
                </td>
                <td class="border px-4 py-2 text-gray-600 dark:text-gray-300">
                    {{ $activity->court_room ?? 'N/A' }}
                </td>
                <td class="border px-4 py-2">
                    {{ $activity->outcome ?? 'N/A' }}
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="5" class="border px-4 py-4 text-center text-gray-500 dark:text-gray-400 italic">
                    No activities recorded.
                </td>
            </tr>
        @endforelse
    </tbody>
</table>
</div>