<div class="overflow-x-auto rounded-md shadow-md border border-gray-200 dark:border-gray-700">
<table class="w-full min-w-full text-center mt-6">
    <thead class="bg-gray-50 dark:bg-gray-900/50">
        <tr>
            <th class="border border-gray-200 px-4 py-2">Invoice No</th>
            <th class="border border-gray-200 px-4 py-2">Client</th>
            <th class="border border-gray-200 px-4 py-2">Status</th>
            <th class="border border-gray-200 px-4 py-2">Amount (KES)</th>
            <th class="border border-gray-200 px-4 py-2">Reference</th>
        </tr>
    </thead>

    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
        @php $invoice = $invoice ?? ($invoices ?? null); @endphp

        @if ($invoice)
            <tr>
                <td class="border border-gray-200 px-4 py-2">{{ $invoice->invoice_number }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ $invoice->client?->user?->name ?? 'N/A' }}</td>
                <td class="border border-gray-200 px-4 py-2 capitalize">{{ $invoice->status }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ number_format($invoice->total_amount, 2) }}</td>
                <td class="border border-gray-200 px-4 py-2">
                    @if ($invoice->payable_type === \App\Models\Conveyancing::class)
                        {{ $invoice->payable?->serial_number ?? 'N/A' }}
                    @elseif ($invoice->payable_type === \App\Models\Litigation::class)
                        {{ $invoice->payable?->case_number ?? 'N/A' }}
                    @elseif ($invoice->payable_type === \App\Models\Project::class)
                        {{ $invoice->payable?->name ?? 'N/A' }}
                    @else
                        {{ $invoice->payable_id ?? 'N/A' }}
                    @endif
                </td>
            </tr>
        @else
            <tr>
                <td colspan="7" class="text-center py-4 text-gray-500">No invoice data found.</td>
            </tr>
        @endif
    </tbody>
</table>
</div>