<div class="overflow-x-auto rounded-md shadow-md border border-gray-200 dark:border-gray-700">
    <table class="w-full text-sm text-left text-gray-600 dark:text-gray-300">
        <thead class="text-xs uppercase bg-gray-100 dark:bg-gray-800 dark:text-gray-400">
            <tr>
                <th class="px-4 py-2 border">Field</th>
                <th class="px-4 py-2 border">Value</th>
            </tr>
        </thead>
        <tbody class="bg-white dark:bg-gray-900">
            <tr>
                <td class="px-4 py-2 border font-medium">Expense Item</td>
                <td class="px-4 py-2 border">
                    {{ $expense->expenseItem->expense_item ?? '—' }}
                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Amount Paid</td>
                <td class="px-4 py-2 border">
                    KES {{ number_format($expense->amount_paid, 2) }}
                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Balance</td>
                <td class="px-4 py-2 border">
                    KES {{ number_format($expense->balance, 2) }}
                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Payment Method</td>
                <td class="px-4 py-2 border">
                    {{ ucfirst($expense->payment_method) }}
                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Status</td>
                <td class="px-4 py-2 border">
                    {{ ucfirst($expense->status) }}
                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Expensable Type</td>
                <td class="px-4 py-2 border">
                    {{ class_basename($expense->expensable_type) }}
                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Related To</td>
                <td class="px-4 py-2 border">
                    @php
                        $expensable = $expense->expensable;
                    @endphp

                    @if ($expensable)
                        @switch(class_basename($expensable))
                            @case('Conveyancing')
                                Conveyancing – {{ $expensable->serial_number ?? 'N/A' }}
                            @break

                            @case('Litigation')
                                Litigation – {{ $expensable->case_number ?? 'N/A' }}
                            @break

                            @case('Project')
                                Project – {{ $expensable->name ?? 'N/A' }}
                            @break

                            @default
                                {{ class_basename($expensable) }} – #{{ $expensable->id }}
                        @endswitch
                    @else
                        <span class="text-gray-500 italic">No associated record</span>
                    @endif
                </td>
            </tr>

        </tbody>
    </table>
</div>
