<div class="max-w-7xl mx-auto p-6">
    @php
        $filePath = $record->file_path;
        $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
        $fileUrl = \Illuminate\Support\Facades\Storage::disk('public')->url($filePath);
        $fileTypeIcon = match ($extension) {
            'pdf' => asset('images/pdf-icon.png'),
            'xlsx', 'xls' => asset('images/excel-icon.png'),
            'doc', 'docx' => asset('images/word-icon.png'),
            default => asset('images/file-icon.png'),
        };
        $associatedEntity = match (class_basename($record->documentable_type)) {
            'Project' => $record->documentable ? "Project: {$record->documentable->name}" : 'N/A',
            'ProjectClient' => $record->documentable?->client ? "Client: {$record->documentable->client->user?->name}" : 'N/A',
            'Conveyancing' => $record->documentable ? "Conveyancing: {$record->documentable->serial_number}" : 'N/A',
            'Litigation' => $record->documentable ? "Litigation: {$record->documentable->case_number}" : 'N/A',
            default => 'N/A',
        };
    @endphp

    <h1 class="text-2xl font-bold mb-6">Document Details</h1>

    <div class="bg-white shadow rounded-lg p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h2 class="text-lg font-semibold mb-4">Document Information</h2>
                <div class="space-y-4">
                    <div>
                        <span class="text-sm font-medium text-gray-500">Document Name</span>
                        <p class="mt-1 text-gray-900">{{ $record->name }}</p>
                    </div>
                    <div>
                        <span class="text-sm font-medium text-gray-500">Associated Entity</span>
                        <p class="mt-1 text-gray-900">{{ $associatedEntity }}</p>
                    </div>
                    <div>
                        <span class="text-sm font-medium text-gray-500">Uploaded At</span>
                        <p class="mt-1 text-gray-900">{{ $record->created_at->format('Y-m-d H:i:s') }}</p>
                    </div>
                    <div>
                        <span class="text-sm font-medium text-gray-500">File Type</span>
                        <div class="mt-1">
                            <img src="{{ $fileTypeIcon }}" alt="File Type Icon" class="h-12 w-12">
                        </div>
                    </div>
                </div>
                <div class="mt-6 flex space-x-4">
                    <a href="{{ $fileUrl }}" target="_blank" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12h.01M12 15h.01M9 12h.01M12 9h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        View
                    </a>
                    <a href="{{ route('filament.resources.documents.download', ['record' => $record->id]) }}" class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                        </svg>
                        Download
                    </a>
                </div>
            </div>
            <div>
                <h2 class="text-lg font-semibold mb-4">Document Preview</h2>
                @if (in_array($extension, ['pdf']))
                    <iframe src="{{ $fileUrl }}" class="w-full h-96 border-0"></iframe>
                @elseif (in_array($extension, ['jpg', 'jpeg', 'png']))
                    <img src="{{ $fileUrl }}" alt="Document Preview" class="max-w-full h-auto">
                @else
                    <p class="text-gray-500">Preview not available for this file type.</p>
                @endif
            </div>
        </div>
    </div>
</div>