@php
    $legalFees = $payments->where('type', 'legal_fees');
    $purchasePrice = $payments->where('type', 'purchase_price');

    $totalLegalFees = $legalFees->sum('amount_paid');
    $totalPurchasePrice = $purchasePrice->sum('amount_paid');
@endphp

{{-- Legal Fees Table --}}
<div class="overflow-x-auto mb-6">
    <h3 class="text-lg font-semibold mb-2">Legal Fees</h3>
    <table class="w-full min-w-full text-center border border-collapse">
        <thead class="bg-gray-50 dark:bg-gray-900/50">
            <tr>
                <th class="border border-gray-200 px-4 py-2">Payer</th>
                <th class="border border-gray-200 px-4 py-2">Method</th>
                <th class="border border-gray-200 px-4 py-2">Type</th>
                <th class="border border-gray-200 px-4 py-2">Date</th>
                <th class="border border-gray-200 px-4 py-2">Amount Paid</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($legalFees as $payment)
                <tr>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ $payment->paidBy?->user?->name ?? '-' }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ ucfirst($payment->payment_method ?? '-') }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ ucfirst(str_replace('_', ' ', $payment->type ?? '-')) }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ \Carbon\Carbon::parse($payment->created_at)->format('M d, Y') }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        KES {{ number_format($payment->amount_paid, 2) }}
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="px-6 py-4 text-gray-500 dark:text-gray-400 text-center">
                        No legal fee payments found.
                    </td>
                </tr>
            @endforelse

            @if ($legalFees->isNotEmpty())
                <tr class="bg-gray-100 dark:bg-gray-800 font-semibold">
                    <td colspan="4" class="text-right px-4 py-2">Total Paid</td>
                    <td class="px-4 py-2">KES {{ number_format($totalLegalFees, 2) }}</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

{{-- Purchase Price Table --}}
<div class="overflow-x-auto">
    <h3 class="text-lg font-semibold mb-2">Purchase Price</h3>
    <table class="w-full min-w-full text-center border border-collapse">
        <thead class="bg-gray-50 dark:bg-gray-900/50">
            <tr>
                <th class="border border-gray-200 px-4 py-2">Payer</th>
                <th class="border border-gray-200 px-4 py-2">Method</th>
                <th class="border border-gray-200 px-4 py-2">Type</th>
                <th class="border border-gray-200 px-4 py-2">Date</th>
                <th class="border border-gray-200 px-4 py-2">Amount Paid</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($purchasePrice as $payment)
                <tr>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ $payment->paidBy?->user?->name ?? '-' }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ ucfirst($payment->payment_method ?? '-') }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ ucfirst(str_replace('_', ' ', $payment->type ?? '-')) }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ \Carbon\Carbon::parse($payment->created_at)->format('M d, Y') }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        KES {{ number_format($payment->amount_paid, 2) }}
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="px-6 py-4 text-gray-500 dark:text-gray-400 text-center">
                        No purchase price payments found.
                    </td>
                </tr>
            @endforelse

            @if ($purchasePrice->isNotEmpty())
                <tr class="bg-gray-100 dark:bg-gray-800 font-semibold">
                    <td colspan="4" class="text-right px-4 py-2">Total Paid</td>
                    <td class="px-4 py-2">KES {{ number_format($totalPurchasePrice, 2) }}</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
