@php
    function getIconPath($filePath)
    {
        $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
        return match ($extension) {
            'pdf' => 'images/pdf-icon.png',
            'doc', 'docx' => 'images/word-icon.png',
            'xls', 'xlsx' => 'images/excel-icon.png',
            'jpg', 'jpeg', 'png', 'gif' => 'storage/' . $filePath,
            default => 'images/file-icon.png',
        };
    }
@endphp

@if (!empty($serial_number))
    <div class="mb-4 text-center">
        <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
            Referrence Number: <span class="text-primary-600 dark:text-primary-400">{{ $serial_number }}</span>
        </h2>
    </div>
@endif

<div class="overflow-x-auto">
    <table class="w-full min-w-full text-center">
        <thead class="bg-gray-50 dark:bg-gray-900/50">
            <tr>
                <th class="border border-gray-200 px-4 py-2 uppercase">Property Details</th>
                <th class="border border-gray-200 px-4 py-2 uppercase">Sale Price</th>
                <th class="border border-gray-200 px-4 py-2 uppercase">Contract Date</th>
                <th class="border border-gray-200 px-4 py-2 uppercase">Settlement Date</th>
                <th class="border border-gray-200 px-4 py-2 uppercase">Documents</th> <!-- New column -->
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="border border-gray-200 px-4 py-2 dark:text-gray-300">{{ $property_address }}</td>
                <td class="border border-gray-200 px-4 py-2 dark:text-gray-300">KES {{ number_format($sale_price, 2) }}
                </td>
                
                <td class="border border-gray-200 px-4 py-2 dark:text-gray-300">
                    {{ \Carbon\Carbon::parse($contract_date)->format('M d, Y') }}
                </td>
                <td class="border border-gray-200 px-4 py-2 dark:text-gray-300">
                    {{ \Carbon\Carbon::parse($settlement_date)->format('M d, Y') }}
                </td>

                <!-- Documents cell -->
                <td class="border border-gray-200 px-4 py-2"  >
                        @if ($documents && $documents->isNotEmpty())
                            <div class="grid grid-cols-2 gap-3 ">
                                @foreach ($documents as $document)
                                    @php
                                        $extension = strtolower(pathinfo($document->file_path, PATHINFO_EXTENSION));

                                        $iconMap = [
                                            'pdf' => 'pdf-icon.png',
                                            'doc' => 'word-icon.png',
                                            'docx' => 'word-icon.png',
                                            'xls' => 'excel-icon.png',
                                            'xlsx' => 'excel-icon.png',
                                            'jpg' => 'image-icon.png',
                                            'jpeg' => 'image-icon.png',
                                            'png' => 'image-icon.png',
                                            'txt' => 'text-icon.png',
                                        ];

                                        $icon = $iconMap[$extension] ?? 'file-icon.png';
                                    @endphp

                                    <div class="flex flex-col items-center text-center">
                                        <a href="{{ asset('storage/' . $document->file_path) }}" target="_blank"
                                            class="flex justify-center">
                                            <img src="{{ asset('images/' . $icon) }}" alt="{{ strtoupper($extension) }}"
                                                class="h-6 w-6 object-contain hover:scale-110 transition">
                                        </a>
                                        <p class="mt-1 text-xs text-gray-700 dark:text-gray-300 truncate w-full">
                                            {{ $document->name }}
                                        </p>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <span class="text-gray-500 dark:text-gray-400 italic">N/A</span>
                        @endif
                </td>

            </tr>
        </tbody>
    </table>
</div>
