<div class="overflow-x-auto">
    <table class="w-full text-sm text-left border dark:border-gray-700">
        <thead class="bg-gray-100 dark:bg-gray-800 text-gray-700 dark:text-gray-300">
            <tr>
                <th class="px-4 py-2 border">#</th>
                <th class="px-4 py-2 border">Address</th>
                <th class="px-4 py-2 border">Client</th>
                <th class="px-4 py-2 border">Advocate Role</th>
                <th class="px-4 py-2 border">Assigned On</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($conveyancings as $index => $conveyancing)
                <tr class="border-t dark:border-gray-700">
                    <td class="px-4 py-2 border">{{ $index + 1 }}</td>
                    <td class="px-4 py-2 border">{{ $conveyancing->property_address ?? 'N/A' }}</td>
                    <td class="px-4 py-2 border">
                        {{ $conveyancing->client->user->name ?? 'N/A' }}
                    </td>
                    <td class="px-4 py-2 border">
                        {{ $conveyancing->pivot->role ?? 'N/A' }}
                    </td>
                    <td class="px-4 py-2 border">
                        {{ $conveyancing->pivot->created_at?->format('d M Y') ?? 'N/A' }}
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="px-4 py-3 text-center text-gray-500">
                        No conveyancing cases assigned to this advocate.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
