<div class="overflow-x-auto">
    <table class="w-full min-w-full border text-center border-gray-300 divide-y divide-gray-200 text-sm">
        <thead class="bg-gray-100">
            <tr>
                <th class="border border-gray-200 px-4 py-2">#</th>
                <th class="border border-gray-200 px-4 py-2">Project Name</th>
                <th class="border border-gray-200 px-4 py-2">Type</th>
                <th class="border border-gray-200 px-4 py-2">Room/Plot Type</th>
                <th class="border border-gray-200 px-4 py-2">Project Cient Report</th>
            </tr>
        </thead>
        <tbody>
            @forelse($projectClients as $projectClient)
                <tr class="divide-x divide-gray-200">
                    {{-- # column --}}
                    <td class="px-4 py-2">{{ $loop->iteration }}</td>

                    {{-- Project Name --}}
                    <td class="px-4 py-2">
                        {{ $projectClient->project->name ?? 'N/A' }}
                    </td>

                    {{-- Project Type --}}
                    <td class="px-4 py-2">
                        {{ ucfirst($projectClient->project->type ?? 'N/A') }}
                    </td>

                    {{-- Room / Plot info --}}
                    <td class="px-4 py-2">
                        @if ($projectClient->project->type === 'apartment')
                            Floor - {{ $projectClient->apartmentDetail->floor ?? 'N/A' }},
                            Hse - {{ $projectClient->apartmentDetail->flat_name ?? 'N/A' }}
                        @elseif($projectClient->project->type === 'subdivision')
                            {{ $projectClient->subdivisionDetail->plot_type ?? 'N/A' }}
                        @else
                            N/A
                        @endif
                    </td>

                    {{-- Download button --}}
                    <td class="px-4 py-2">
                        <a href="{{ route('filament.resources.projects.client-pdf', ['record' => $projectClient->project->id, 'projectClient' => $projectClient->id]) }}"
                            target="_blank"
                            class="inline-flex items-center px-3 py-1 text-sm font-medium rounded-lg bg-primary-600 text-white hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                            Download 
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="px-4 py-2 text-center text-gray-500">
                        No projects found.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
