<div class="overflow-x-auto">

    <table class="w-full min-w-full border border-gray-300 divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-100">
            <tr>
                <th class="border border-gray-200 px-4 py-2">Case</th>
                <th class="border border-gray-200 px-4 py-2">Date</th>
                <th class="border border-gray-200 px-4 py-2">Amount Paid</th>
                <th class="border border-gray-200 px-4 py-2">Payment Method</th>
                <th class="border border-gray-200 px-4 py-2">Status</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
            @forelse ($payments as $payment)
                <tr>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ $payment->litigation->case_number ?? 'N/A' }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ \Carbon\Carbon::parse($payment->created_at)->format('M d, Y') }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        Ksh {{ number_format($payment->amount_paid, 2) }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ ucfirst($payment->payment_method) }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2 dark:text-gray-300">
                        <x-filament::badge :color="match (strtolower($payment->status)) {
                            'completed' => 'success',
                            'failed' => 'danger',
                            'pending' => 'warning',
                            default => 'gray',
                        }">
                            {{ ucwords(str_replace('_', ' ', $payment->status)) }}
                        </x-filament::badge>
                    </td>

                </tr>
            @empty
                <tr>
                    <td colspan="5" class="border border-gray-200 px-4 py-2 text-center text-gray-500">
                        No payments found.
                    </td>
                </tr>
            @endforelse
        </tbody>

        @if ($payments->count())
            <tfoot>
                <tr class="bg-gray-100 dark:bg-gray-900/30 font-semibold">
                    <td colspan="2" class="border border-gray-200 px-4 py-2 text-right">Total Paid:</td>
                    <td colspan="3" class="border border-gray-200 px-4 py-2 text-left">
                        Ksh {{ number_format($total, 2) }}
                    </td>
                </tr>
            </tfoot>
        @endif
    </table>
</div>