<div class="overflow-x-auto">

    <table class="w-full min-w-full border border-gray-300 divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-100">
            <tr>
                <th class="border border-gray-200 px-4 py-2">Case Number</th>
                <th class="border border-gray-200 px-4 py-2">Court</th>
                <th class="border border-gray-200 px-4 py-2">Filed Date</th>
                <th class="border border-gray-200 px-4 py-2">Status</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
            @forelse ($litigations as $litigation)
                <tr>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ $litigation->case_number ?? 'N/A' }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ $litigation->station ?? 'N/A' }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ \Carbon\Carbon::parse($litigation->filed_at)->format('M d, Y') ?? 'N/A' }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2 dark:text-gray-300">
                        <x-filament::badge :color="match (strtolower($litigation->status)) {
                            'open' => 'success',
                            'appealed' => 'info',
                            'closed' => 'danger',
                            'pending' => 'warning',
                            default => 'gray',
                        }">
                            {{ ucwords(str_replace('_', ' ', $litigation->status)) }}
                        </x-filament::badge>
                    </td>

                </tr>
            @empty
                <tr>
                    <td colspan="5" class="border border-gray-200 px-4 py-2 text-center text-gray-500">
                        No litigations found for this client.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>