<div class="overflow-x-auto">
    <div class="max-h-80 overflow-y-auto">
        <div class="flex flex-wrap gap-4"> {{-- Added flex container with gap --}}
            @forelse ($clientDocuments as $document)
                @php
                    $extension = strtolower(pathinfo($document->file_path, PATHINFO_EXTENSION));

                    $iconMap = [
                        'pdf'  => 'pdf-icon.png',
                        'doc'  => 'word-icon.png',
                        'docx' => 'word-icon.png',
                        'xls'  => 'excel-icon.png',
                        'xlsx' => 'excel-icon.png',
                        'txt'  => 'text-icon.png',
                    ];

                    $isImage = in_array($extension, ['jpg', 'jpeg', 'png']);
                    $icon = $iconMap[$extension] ?? 'file-icon.png';
                @endphp

                <div class="flex-none w-16"> {{-- Fixed width container for each item --}}
                    <a href="{{ asset('storage/' . $document->file_path) }}" target="_blank" class="block">
                        <div class="w-16 h-16 flex items-center justify-center bg-gray-100 dark:bg-gray-800 
                                    rounded-md shadow border border-gray-200 hover:scale-105 transition 
                                    overflow-hidden">
                            @if ($isImage)
                                <img src="{{ asset('storage/' . $document->file_path) }}"
                                     alt="ID Image"
                                     class="w-full h-full object-cover" />
                            @else
                                <img src="{{ asset('images/' . $icon) }}"
                                     alt="{{ strtoupper($extension) }}"
                                     class="w-12 h-12 object-contain" />
                            @endif
                        </div>
                    </a>
                    <p class="mt-1 text-[10px] text-center truncate w-16"
                       title="{{ $document->name ?? basename($document->file_path) }}">
                        {{ $document->name ?? basename($document->file_path) }}
                    </p>
                </div>
            @empty
                <p class="text-sm text-gray-500">No documents uploaded.</p>
            @endforelse
        </div>
    </div>
</div>