<div class="overflow-x-auto">
     <table class="w-full min-w-full border border-gray-300 divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-100">
            <tr>
                <th class="border border-gray-200 px-4 py-2">Property Address</th>
                <th class="border border-gray-200 px-4 py-2">Buyer</th>
                <th class="border border-gray-200 px-4 py-2">Seller</th>
                <th class="border border-gray-200 px-4 py-2">Sale Price</th>
                <th class="border border-gray-200 px-4 py-2">Status</th>
                <th class="border border-gray-200 px-4 py-2">Contract Date</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
            @forelse ($conveyancings as $conveyancing)
                @php
                    $status = strtolower($conveyancing->status);
                    $badgeClasses = match ($status) {
                        'ongoing' => 'bg-blue-100 text-blue-800 dark:bg-blue-900/50 dark:text-blue-300',
                        'completed' => 'bg-green-100 text-green-800 dark:bg-green-900/50 dark:text-green-300',
                        'cancelled' => 'bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300',
                        default => 'bg-gray-100 text-gray-800 dark:bg-gray-900/50 dark:text-gray-300',
                    };
                @endphp
                <tr>
                    <td class="border border-gray-200 px-4 py-2">{{ $conveyancing->property_address ?? 'N/A' }}</td>
                    <td class="border border-gray-200 px-4 py-2">{{ $conveyancing->buyer->user->name ?? 'N/A' }}</td>
                    <td class="border border-gray-200 px-4 py-2">{{ $conveyancing->seller->user->name ?? 'N/A' }}</td>
                    <td class="border border-gray-200 px-4 py-2">Ksh {{ number_format($conveyancing->sale_price, 2) }}
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        <span class="inline-block px-3 py-1 text-xs font-semibold rounded-full {{ $badgeClasses }}">
                            {{ ucfirst($conveyancing->status) }}
                        </span>
                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        {{ \Carbon\Carbon::parse($conveyancing->contract_date)->format('M d, Y') ?? 'N/A' }}
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="border border-gray-200 px-4 py-2 text-center text-gray-500">
                        No conveyancing records found for this client.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
