@php
    $groupedPayments = $payments->groupBy('conveyancing_id');
    $grandTotal = 0;
@endphp

@forelse ($groupedPayments as $conveyancingId => $paymentGroup)
    @php
        $conveyancing = $paymentGroup->first()->conveyancing ?? null;
        $total = $paymentGroup->sum('amount_paid');
        $grandTotal += $total;
    @endphp

    <div class="mb-6">
        <h3 class="text-left font-semibold text-sm mb-2">
            Conveyancing: {{ $conveyancing->property_address ?? 'Property #'.$conveyancingId }}
        </h3>
        <div class="overflow-x-auto">
         <table class="w-full min-w-full border border-gray-300 divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border border-gray-200 px-4 py-2">Paid To</th>
                    <th class="border border-gray-200 px-4 py-2">Paid By</th>
                    <th class="border border-gray-200 px-4 py-2">Amount Received</th>
                    <th class="border border-gray-200 px-4 py-2">Method</th>
                    <th class="border border-gray-200 px-4 py-2">Transaction ID</th>
                    <th class="border border-gray-200 px-4 py-2">Status</th>
                    <th class="border border-gray-200 px-4 py-2">Created At</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                @foreach ($paymentGroup as $payment)
                    @php
                        $status = strtolower($payment->status);
                        $badgeClasses = match ($status) {
                            'confirmed' => 'bg-green-100 text-green-800 dark:bg-green-900/50 dark:text-green-300',
                            'pending' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/50 dark:text-yellow-300',
                            'failed' => 'bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300',
                            default => 'bg-gray-100 text-gray-800 dark:bg-gray-900/50 dark:text-gray-300',
                        };
                    @endphp
                    <tr>
                        <td class="border border-gray-200 px-4 py-2"> {{ ($payment->client->user->name) }}</td>
                        <td class="border border-gray-200 px-4 py-2"> {{ ($payment->paidBy->user->name ?? 'NA') }}</td>
                        <td class="border border-gray-200 px-4 py-2">Ksh {{ number_format($payment->amount_paid, 2) }}</td>
                        <td class="border border-gray-200 px-4 py-2">{{ ucfirst($payment->payment_method) }}</td>
                        <td class="border border-gray-200 px-4 py-2">{{ $payment->transaction_id ?? '-' }}</td>
                        <td class="border border-gray-200 px-4 py-2">
                            <span class="inline-block px-3 py-1 text-xs font-semibold rounded-full {{ $badgeClasses }}">
                                {{ ucfirst($payment->status) }}
                            </span>
                        </td>
                         <td class="border border-gray-200 px-4 py-2">
                    {{ \Carbon\Carbon::parse($payment->created_at)->format('M d, Y') ?? 'N/A' }}
                </td>
                    </tr>
                @endforeach
                <tr class="font-bold bg-gray-100 dark:bg-gray-800">
                    <td colspan="1" class="border border-gray-200 px-4 py-2 text-right">Total:</td>
                    <td colspan="4" class="border border-gray-200 px-4 py-2 text-left">
                        Ksh {{ number_format($total, 2) }}
                    </td>
                </tr>
            </tbody>
        </table>
        </div>
    </div>
@empty
    <p class="text-center text-gray-500">No conveyancing payments found for this client.</p>
@endforelse

@if ($payments->count())
    <div class="mt-4 text-right font-bold text-sm">
        Grand Total: Ksh {{ number_format($grandTotal, 2) }}
    </div>
@endif
