<div class="overflow-x-auto">

<table class="w-full min-w-full text-center">
    <thead class="bg-gray-50 dark:bg-gray-900/50">
        <tr>
            <th class="border border-gray-200 px-4 py-2">Case Number</th>
            <th class="border border-gray-200 px-4 py-2">Client</th>
            <th class="border border-gray-200 px-4 py-2">Court</th>
            <th class="border border-gray-200 px-4 py-2">Status</th>
        </tr>
    </thead>
    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
        @forelse ($litigations as $litigation)
            <tr>
                <td class="border border-gray-200 px-4 py-2">{{ $litigation->case_number }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ $litigation->client->user->name ?? 'N/A' }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ $litigation->court_name }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ ucfirst($litigation->status) }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="4" class="text-center italic text-gray-500 px-4 py-2">No litigation cases found.</td>
            </tr>
        @endforelse
    </tbody>
</table>
</div>
