@if ($groupedStages->isEmpty())
    <p class="italic text-gray-500">No litigation stages assigned to this advocate.</p>
@else
    @foreach ($groupedStages as $litigationId => $stages)
        @php
            $litigation = $stages->first()->litigation ?? null;
        @endphp

        @if ($litigation)
            <h2 class="text-lg font-semibold text-gray-800 dark:text-gray-200 mt-6 mb-2">
                {{ $litigation->case_number ?? 'Unknown Case' }}
            </h2>

            <table class="w-full min-w-full text-center mb-6">
                <thead class="bg-gray-50 dark:bg-gray-900/50">
                    <tr>
                        <th class="border border-gray-200 px-4 py-2">Stage Description</th>
                        <th class="border border-gray-200 px-4 py-2">Status</th>
                        <th class="border border-gray-200 px-4 py-2">Start - End</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                    @foreach ($stages as $stage)
                        <tr>
                            <td class="border border-gray-200 px-4 py-2 italic">{{ $stage->description }}</td>
                            <td class="border border-gray-200 px-4 py-2">{{ ucfirst($stage->status) }}</td>
                            <td class="border border-gray-200 px-4 py-2">
                                {{ \Carbon\Carbon::parse($stage->start_date)->format('M d, Y') }}
                                to
                                {{ \Carbon\Carbon::parse($stage->end_date)->format('M d, Y') }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    @endforeach
@endif
