<table class="w-full min-w-full text-center">
    <thead class="bg-gray-50 dark:bg-gray-900/50">
        <tr>
            <th class="border border-gray-200 px-4 py-2">Client</th>
            <th class="border border-gray-200 px-4 py-2">Method</th>
            <th class="border border-gray-200 px-4 py-2">Status</th>
            <th class="border border-gray-200 px-4 py-2">Amount</th>
        </tr>
    </thead>
    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
        @forelse ($payments as $payment)
            <tr>
                <td class="border border-gray-200 px-4 py-2">{{ $payment->client->user->name ?? 'N/A' }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ ucfirst($payment->payment_method) }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ ucfirst($payment->status) }}</td>
                <td class="border border-gray-200 px-4 py-2">{{ number_format($payment->amount_paid, 2) }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="4" class="text-center italic text-gray-500 px-4 py-2">No payments recorded.</td>
            </tr>
        @endforelse

        @if ($payments && $payments->count())
            <tr class="bg-gray-100 dark:bg-gray-800 font-semibold">
                <td colspan="3" class="text-right px-4 py-2">Total Paid:</td>
                <td class="px-4 py-2 text-green-700 dark:text-green-400">
                    {{ number_format($total, 2) }}
                </td>
            </tr>
        @endif
    </tbody>
</table>
