<x-filament-panels::page>
    <style>
        .container {
            padding: 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 14px;
            max-width: 1400px;
            margin: 0 auto;
            line-height: 1.6;
            background-color: #fefefe;
            color: #1a1a1a;
        }

        body {
            background-color: #f8f6f0 !important;
            color: #1a1a1a !important;
        }

        h1 {
            font-size: 28px;
            font-weight: 700;
            margin: 20px 0 30px 0;
            color: #1a1a1a;
            text-align: center;
            letter-spacing: -0.5px;
        }

        /* Enhanced Filament form sections with flexible layout */
        .fi-section {
            border: 2px solid #8b7355;
            background: #fefefe;
            margin: 25px 0;
            border-radius: 12px;
            overflow: visible; /* Changed from hidden to visible for dropdowns */
            box-shadow: 0 4px 12px rgba(139, 115, 85, 0.15);
            transition: all 0.3s ease;
            position: relative;
            z-index: 1;
        }

        .fi-section:hover {
            box-shadow: 0 6px 20px rgba(139, 115, 85, 0.25);
            transform: translateY(-2px);
            z-index: 2; /* Ensure hovered sections are above others */
        }

        .fi-section-header {
            background: linear-gradient(135deg, #f5f3ef 0%, #ebe7df 100%);
            padding: 16px 20px;
            font-weight: 600;
            text-align: center;
            border-bottom: 2px solid #8b7355;
            font-size: 17px;
            color: #1a1a1a;
            letter-spacing: 0.2px;
            border-radius: 10px 10px 0 0;
        }

        .fi-section-content {
            padding: 0 !important;
            background: #fefefe !important;
            border: none !important;
            overflow: visible !important;
        }

        /* Flexible grid layout that adapts to field count */
        .fi-fo-section-content-ctn {
            display: flex;
            flex-wrap: wrap;
            gap: 24px;
            padding: 32px;
            align-items: flex-start;
            background: #fefefe;
            min-height: auto;
            overflow: visible;
        }

        /* Dynamic field width based on content */
        .fi-fo-field-wrp {
            flex: 1 1 300px; /* Flexible grow/shrink, minimum 300px */
            min-width: 280px;
            max-width: 100%;
            margin-bottom: 24px;
            position: relative;
            z-index: 1;
        }

        /* Special handling for fields with many options */
        .fi-fo-field-wrp.large-dropdown {
            flex: 1 1 400px;
            min-width: 380px;
        }

        .fi-fo-field-wrp.full-width {
            flex: 1 1 100%;
            min-width: 100%;
        }

        .fi-fo-field-wrp label {
            display: block;
            font-weight: 600;
            margin-bottom: 8px;
            color: #1a1a1a;
            font-size: 14px;
            letter-spacing: 0.1px;
            transition: color 0.2s ease;
        }

        .fi-fo-field-wrp:focus-within label {
            color: #8b7355;
        }

        /* Enhanced input and select styling with proper dropdown support */
        .fi-input, .fi-select-input {
            width: 100%;
            padding: 14px 18px;
            border: 2px solid #8b7355;
            font-size: 15px;
            border-radius: 8px;
            box-sizing: border-box;
            background: #fefefe;
            color: #1a1a1a;
            transition: all 0.3s ease;
            font-family: inherit;
            appearance: none;
            position: relative;
            min-height: 50px;
            line-height: 1.4;
            z-index: 1;
        }

        .fi-input:focus, .fi-select-input:focus {
            outline: none;
            border-color: #6d5a42;
            box-shadow: 0 0 0 3px rgba(139, 115, 85, 0.2);
            transform: translateY(-1px);
            background: #fefefe;
            z-index: 100; /* High z-index when focused */
        }

        .fi-input:hover, .fi-select-input:hover {
            border-color: #6d5a42;
            background: #fefefe;
        }

        /* Enhanced dropdown styling with proper z-index management */
        .fi-select-input {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%23000000' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M6 8l4 4 4-4'/%3e%3c/svg%3e");
            background-position: right 16px center;
            background-repeat: no-repeat;
            background-size: 18px;
            background-color: #fefefe;
            padding-right: 50px !important;
            cursor: pointer;
            position: relative;
            z-index: 1;
        }

        .fi-select-input:focus {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236d5a42' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M6 8l4 4 4-4'/%3e%3c/svg%3e");
            background-color: #fefefe;
            z-index: 100;
            position: relative;
        }

        /* Ensure dropdown options are properly styled and visible */
        .fi-select-input option {
            padding: 12px 16px;
            background: #fefefe;
            color: #1a1a1a;
            font-size: 15px;
            border: none;
            min-height: 44px;
            line-height: 1.4;
            position: relative;
            z-index: 101;
        }

        .fi-select-input option:hover {
            background: #f5f3ef;
            color: #1a1a1a;
        }

        .fi-select-input option:checked,
        .fi-select-input option:selected {
            background: #8b7355;
            color: #fefefe;
            font-weight: 600;
        }

        /* Fix for Filament select styling conflicts with enhanced z-index */
        .fi-input-wrapper, 
        .fi-select,
        .fi-input-wrapper .fi-select-input,
        .fi-select .fi-select-input {
            position: relative;
            z-index: 1;
        }

        .fi-input-wrapper .fi-select-input,
        .fi-select .fi-select-input {
            padding: 14px 50px 14px 18px !important;
            background-position: right 16px center !important;
            background-size: 18px !important;
            min-height: 50px !important;
            background-color: #fefefe !important;
            color: #1a1a1a !important;
        }

        .fi-input-wrapper:focus-within,
        .fi-select:focus-within {
            z-index: 100;
        }

        /* Enhanced summary section */
        .summary-section {
            border: 2px solid #8b7355;
            background: #fefefe;
            margin: 30px 0;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 6px 16px rgba(139, 115, 85, 0.2);
        }

        .summary-header {
            background: linear-gradient(135deg, #8b7355 0%, #6d5a42 100%);
            padding: 18px 24px;
            font-weight: 700;
            text-align: center;
            border-bottom: none;
            font-size: 18px;
            color: #fefefe;
            letter-spacing: 0.3px;
            text-transform: uppercase;
            font-size: 16px;
        }

        .summary-content {
            padding: 28px;
            background: #fefefe;
            border-radius: 0;
            margin: 0;
        }

        .summary-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 32px;
        }

        .summary-item {
            margin-bottom: 16px;
            padding: 12px 0;
            border-bottom: 1px solid #d4c4a8;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }

        .summary-item:last-child {
            border-bottom: none;
        }

        .summary-label {
            font-weight: 600;
            color: #1a1a1a;
            font-size: 14px;
            min-width: 120px;
            margin-bottom: 4px;
        }

        .summary-value {
            color: #4a4a4a;
            font-weight: 500;
            font-size: 14px;
            text-align: right;
            flex: 1;
        }

        /* Enhanced button styling */
        .fi-btn {
            font-size: 16px !important;
            padding: 16px 40px !important;
            border-radius: 10px !important;
            font-weight: 600 !important;
            letter-spacing: 0.3px !important;
            transition: all 0.3s ease !important;
            text-transform: uppercase !important;
            font-size: 14px !important;
            background: linear-gradient(135deg, #8b7355 0%, #6d5a42 100%) !important;
            color: #fefefe !important;
            border: 2px solid #8b7355 !important;
            box-shadow: 0 4px 12px rgba(139, 115, 85, 0.3) !important;
            cursor: pointer !important;
        }

        .fi-btn:hover {
            transform: translateY(-2px) !important;
            box-shadow: 0 6px 20px rgba(139, 115, 85, 0.4) !important;
            background: linear-gradient(135deg, #6d5a42 0%, #5a4936 100%) !important;
            border-color: #6d5a42 !important;
        }

        .fi-btn:active {
            transform: translateY(0) !important;
            box-shadow: 0 2px 8px rgba(139, 115, 85, 0.3) !important;
        }

        .fi-btn-label {
            color: #fefefe !important;
            font-weight: 600 !important;
        }

        .process-btn {
            margin: 32px 0;
            text-align: center;
        }

        /* Enhanced responsive design with better field management */
        @media (min-width: 1200px) {
            /* Large screens: up to 4 fields per row */
            .fi-fo-section-content-ctn {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
                gap: 24px;
            }
            
            .fi-fo-field-wrp {
                margin-bottom: 24px;
                flex: none;
            }
        }

        @media (min-width: 768px) and (max-width: 1199px) {
            /* Medium screens: up to 3 fields per row */
            .fi-fo-section-content-ctn {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
                gap: 20px;
            }
        }

        @media (max-width: 1024px) {
            .container {
                padding: 16px;
                background-color: #f8f6f0;
            }

            .fi-fo-section-content-ctn {
                gap: 20px;
                padding: 28px;
                display: flex;
                flex-wrap: wrap;
            }

            .fi-fo-field-wrp {
                flex: 1 1 280px;
                min-width: 280px;
                margin-bottom: 20px;
            }

            .summary-grid {
                grid-template-columns: 1fr;
                gap: 24px;
            }
        }

        @media (max-width: 768px) {
            .container {
                padding: 12px;
                background-color: #f8f6f0;
            }

            h1 {
                font-size: 24px;
                margin: 16px 0 24px 0;
                color: #1a1a1a;
            }

            .fi-fo-section-content-ctn {
                display: flex;
                flex-direction: column;
                gap: 20px;
                padding: 24px;
                background: #fefefe;
            }

            .fi-fo-field-wrp {
                flex: 1 1 100%;
                min-width: 100%;
                margin-bottom: 20px;
            }

            .fi-section {
                margin: 20px 0;
                border-radius: 8px;
                overflow: visible;
            }

            .fi-section-header {
                padding: 16px;
                font-size: 16px;
                color: #1a1a1a;
            }

            .summary-content {
                padding: 24px;
                background: #fefefe;
            }

            .summary-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }

            .summary-item {
                flex-direction: column;
                align-items: flex-start;
                padding: 12px 0;
                margin-bottom: 12px;
            }

            .summary-label {
                min-width: auto;
                margin-bottom: 6px;
                font-size: 13px;
                color: #1a1a1a;
            }

            .summary-value {
                text-align: left;
                font-size: 14px;
                font-weight: 600;
                color: #4a4a4a;
            }

            .fi-btn {
                padding: 14px 28px !important;
                font-size: 15px !important;
            }

            .process-btn {
                margin: 28px 0;
            }
        }

        @media (max-width: 480px) {
            .container {
                padding: 8px;
                background-color: #f8f6f0;
            }

            .fi-fo-section-content-ctn {
                padding: 20px;
                gap: 16px;
                background: #fefefe;
                display: flex;
                flex-direction: column;
            }

            .fi-fo-field-wrp {
                margin-bottom: 20px;
                flex: 1 1 100%;
                min-width: 100%;
            }

            .fi-input, .fi-select-input {
                padding: 14px 16px;
                font-size: 16px; /* Prevents zoom on iOS */
                min-height: 52px;
                background: #fefefe;
                color: #1a1a1a;
                border-color: #8b7355;
            }

            .fi-select-input {
                padding-right: 50px !important;
                background-size: 18px;
                background-position: right 14px center;
                background-color: #fefefe !important;
            }

            .fi-input-wrapper .fi-select-input,
            .fi-select .fi-select-input {
                padding: 14px 50px 14px 16px !important;
                background-position: right 14px center !important;
                background-size: 18px !important;
                min-height: 52px !important;
                background-color: #fefefe !important;
                color: #1a1a1a !important;
            }

            .summary-header {
                padding: 14px;
                font-size: 15px;
                color: #fefefe;
            }

            .fi-section-header {
                padding: 14px;
                font-size: 15px;
                color: #1a1a1a;
            }

            .summary-content {
                padding: 20px;
                background: #fefefe;
            }
        }

        /* Loading states and interactions */
        .fi-input:disabled, .fi-select-input:disabled {
            background-color: #f0ede7;
            color: #8a8a8a;
            cursor: not-allowed;
            opacity: 0.7;
            border-color: #c4b59a;
        }

        /* Enhanced focus states for better accessibility */
        .fi-btn:focus {
            outline: 2px solid #8b7355 !important;
            outline-offset: 2px !important;
        }

        .fi-input:focus, .fi-select-input:focus {
            outline: none;
            position: relative;
            z-index: 100;
        }

        /* Hide default Filament conflicting styles */
        .fi-section-header-heading {
            display: none;
        }

        /* Improved form field spacing and animations */
        .fi-fo-field-wrp + .fi-fo-field-wrp {
            margin-top: 0;
        }

        /* Animation for dynamically shown fields */
        .fi-fo-field-wrp[x-show] {
            animation: fadeInUp 0.3s ease-in-out;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(-15px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Ensure adequate spacing between all form fields */
        .fi-fo-section-content-ctn > .fi-fo-field-wrp {
            margin-bottom: 24px;
        }

        .fi-fo-section-content-ctn > .fi-fo-field-wrp:last-child {
            margin-bottom: 0;
        }

        /* Better visual hierarchy and spacing */
        .fi-section:first-of-type {
            margin-top: 0;
        }

        .fi-section:last-of-type {
            margin-bottom: 24px;
        }

        /* Enhanced visual feedback with better contrast */
        .fi-input:valid {
            border-color: #10b981;
            box-shadow: 0 0 0 1px rgba(16, 185, 129, 0.1);
        }

        .fi-input:invalid:not(:placeholder-shown) {
            border-color: #ef4444;
            box-shadow: 0 0 0 1px rgba(239, 68, 68, 0.1);
        }

        /* Override any dark mode completely */
        .container, .fi-section, .fi-fo-section-content-ctn, .summary-content,
        .fi-input, .fi-select-input, .fi-fo-field-wrp {
            background-color: #fefefe !important;
            color: #1a1a1a !important;
        }

        /* Force text visibility everywhere */
        *, *::before, *::after {
            color: #1a1a1a !important;
        }

        /* Exception for buttons and headers */
        .fi-btn, .fi-btn *, .summary-header, .summary-header * {
            color: #fefefe !important;
        }

        .summary-value {
            color: #4a4a4a !important;
        }

        /* Ensure proper stacking context for dropdowns */
        .fi-fo-section-content-ctn {
            position: relative;
            z-index: 0;
        }

        .fi-fo-field-wrp:focus-within {
            z-index: 50;
        }

        .fi-select-input:focus {
            z-index: 100;
        }

        /* Ensure select options are always visible */
        select.fi-select-input {
            position: relative;
            z-index: 1;
        }

        select.fi-select-input:focus {
            z-index: 1000;
            position: relative;
        }

        /* Custom utility classes for special field types */
        .fi-fo-field-wrp.priority-field {
            order: -1; /* Move important fields to the front */
        }

        .fi-fo-field-wrp.secondary-field {
            order: 1; /* Move less important fields to the back */
        }

        /* Enhanced container for better field distribution */
        .fi-fo-section-content-ctn.auto-layout {
            display: flex;
            flex-wrap: wrap;
            align-content: flex-start;
            justify-content: flex-start;
        }

        .fi-fo-section-content-ctn.grid-layout {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            align-items: start;
        }
    </style>

    <div class="container">
        <form wire:submit="create">
            {{ $this->form }}
            
            <!-- Custom Summary Section -->
            <div class="summary-section">
                <div class="summary-header">Transaction Summary</div>
                <div class="summary-content">
                    <div class="summary-grid">
                        <div>
                            <div class="summary-item">
                                <span class="summary-label">Direction:</span>
                                <span class="summary-value">
                                    {{ $this->data['direction'] === 'outgoing' ? 'Payment' : ($this->data['direction'] === 'incoming' ? 'Deposit' : '-') }}
                                </span>
                            </div>
                            <div class="summary-item">
                                <span class="summary-label">Type:</span>
                                <span class="summary-value">
                                    {{ $this->data['payable_type'] ? str_replace('App\\Models\\', '', $this->data['payable_type']) : '-' }}
                                </span>
                            </div>
                            <div class="summary-item">
                                <span class="summary-label">Entity:</span>
                                <span class="summary-value">
                                    @if($this->data['payable_id'])
                                        @php
                                            $entity = null;
                                            if ($this->data['payable_type'] && $this->data['payable_id']) {
                                                try {
                                                    $model = $this->data['payable_type'];
                                                    $entity = $model::find($this->data['payable_id']);
                                                } catch (\Exception $e) {
                                                    // Handle error silently
                                                }
                                            }
                                        @endphp
                                        @if($entity)
                                            @switch($this->data['payable_type'])
                                                @case('App\Models\Salary')
                                                    {{ $entity->employee_name ?? $entity->name ?? 'Salary' }} 
                                                    @if($entity->period) ({{ $entity->period }}) @endif
                                                    @break
                                                @case('App\Models\OfficeUtility')
                                                    {{ $entity->type ?? $entity->name ?? 'Utility' }} 
                                                    @if($entity->period) ({{ $entity->period }}) @endif
                                                    @break
                                                @case('App\Models\Project')
                                                    {{ $entity->name ?? 'Project #' . $entity->id }}
                                                    @break
                                                @case('App\Models\Conveyancing')
                                                    {{ $entity->serial_number ?? 'Conveyancing #' . $entity->id }}
                                                    @break
                                                @case('App\Models\Litigation')
                                                    {{ $entity->case_number ?? 'Litigation #' . $entity->id }}
                                                    @break
                                                @default
                                                    Selected Entity
                                            @endswitch
                                        @else
                                            Selected Entity
                                        @endif
                                    @else
                                        -
                                    @endif
                                </span>
                            </div>
                            <div class="summary-item">
                                <span class="summary-label">Client:</span>
                                <span class="summary-value">
                                    @if($this->data['client_id'])
                                        @php
                                            $client = \App\Models\Client::with('user')->find($this->data['client_id']);
                                        @endphp
                                        {{ $client?->user?->name ?? $client?->phone ?? 'Client #' . $this->data['client_id'] }}
                                    @else
                                        No Client
                                    @endif
                                </span>
                            </div>
                        </div>
                        <div>
                            <div class="summary-item">
                                <span class="summary-label">Amount:</span>
                                <span class="summary-value">
                                    KSh {{ number_format((float)($this->data['amount_paid'] ?? 0), 2) }}
                                </span>
                            </div>
                            <div class="summary-item">
                                <span class="summary-label">Method:</span>
                                <span class="summary-value">
                                    @switch($this->data['payment_method'] ?? '')
                                        @case('mpesa')
                                            M-Pesa
                                            @break
                                        @case('bank')
                                            Bank Transfer
                                            @break
                                        @case('cash')
                                            Cash
                                            @break
                                        @default
                                            -
                                    @endswitch
                                </span>
                            </div>
                            @if($this->data['transaction_id'])
                                <div class="summary-item">
                                    <span class="summary-label">Transaction ID:</span>
                                    <span class="summary-value">{{ $this->data['transaction_id'] }}</span>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Process button -->
            <div class="process-btn">
                <button type="submit" class="fi-btn fi-color-primary fi-btn-color-primary fi-size-md fi-btn-size-md">
                    <span class="fi-btn-label">
                        ✓ Process Transaction
                    </span>
                </button>
            </div>
        </form>
    </div>

    @if(session('pdf_download'))
        <script>
            window.location.href = '{{ Storage::url(session('pdf_download')) }}';
        </script>
    @endif

    <!-- JavaScript for enhanced dropdown visibility -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Function to ensure dropdown visibility
            function enhanceDropdownVisibility() {
                const selectInputs = document.querySelectorAll('.fi-select-input');
                
                selectInputs.forEach(function(select) {
                    select.addEventListener('focus', function() {
                        // Ensure the focused select has the highest z-index
                        this.style.zIndex = '1000';
                        this.style.position = 'relative';
                        
                        // Add some extra space if needed
                        const fieldWrapper = this.closest('.fi-fo-field-wrp');
                        if (fieldWrapper) {
                            fieldWrapper.style.zIndex = '999';
                            fieldWrapper.style.position = 'relative';
                        }
                    });
                    
                    select.addEventListener('blur', function() {
                        // Reset z-index after blur
                        setTimeout(() => {
                            this.style.zIndex = '1';
                            const fieldWrapper = this.closest('.fi-fo-field-wrp');
                            if (fieldWrapper) {
                                fieldWrapper.style.zIndex = '1';
                            }
                        }, 200);
                    });
                    
                    // Handle click events
                    select.addEventListener('click', function(e) {
                        this.style.zIndex = '1000';
                        this.style.position = 'relative';
                    });
                });
            }
            
            // Function to adjust form layout based on field count
            function adjustFormLayout() {
                const sections = document.querySelectorAll('.fi-fo-section-content-ctn');
                
                sections.forEach(function(section) {
                    const fieldCount = section.querySelectorAll('.fi-fo-field-wrp').length;
                    
                    // Add appropriate class based on field count
                    if (fieldCount <= 4) {
                        section.classList.add('grid-layout');
                        section.classList.remove('auto-layout');
                    } else {
                        section.classList.add('auto-layout');
                        section.classList.remove('grid-layout');
                    }
                    
                    // Add special handling for large dropdowns
                    const selectFields = section.querySelectorAll('.fi-select-input');
                    selectFields.forEach(function(select) {
                        const optionCount = select.options ? select.options.length : 0;
                        const fieldWrapper = select.closest('.fi-fo-field-wrp');
                        
                        if (optionCount > 10 && fieldWrapper) {
                            fieldWrapper.classList.add('large-dropdown');
                        }
                    });
                });
            }
            
            // Initialize enhancements
            enhanceDropdownVisibility();
            adjustFormLayout();
            
            // Re-run on dynamic content changes (for Livewire updates)
            document.addEventListener('livewire:updated', function() {
                setTimeout(() => {
                    enhanceDropdownVisibility();
                    adjustFormLayout();
                }, 100);
            });
            
            // Handle window resize to adjust layout
            let resizeTimeout;
            window.addEventListener('resize', function() {
                clearTimeout(resizeTimeout);
                resizeTimeout = setTimeout(() => {
                    adjustFormLayout();
                }, 250);
            });
            
            // Enhanced form validation feedback
            function addValidationFeedback() {
                const inputs = document.querySelectorAll('.fi-input, .fi-select-input');
                
                inputs.forEach(function(input) {
                    input.addEventListener('blur', function() {
                        if (this.checkValidity()) {
                            this.classList.add('valid');
                            this.classList.remove('invalid');
                        } else if (this.value.trim() !== '') {
                            this.classList.add('invalid');
                            this.classList.remove('valid');
                        }
                    });
                    
                    input.addEventListener('input', function() {
                        if (this.classList.contains('invalid') && this.checkValidity()) {
                            this.classList.add('valid');
                            this.classList.remove('invalid');
                        }
                    });
                });
            }
            
            addValidationFeedback();
            
            // Smooth scroll to first invalid field on form submission
            const form = document.querySelector('form');
            if (form) {
                form.addEventListener('submit', function(e) {
                    const firstInvalid = form.querySelector('.fi-input:invalid, .fi-select-input:invalid');
                    if (firstInvalid) {
                        setTimeout(() => {
                            firstInvalid.scrollIntoView({
                                behavior: 'smooth',
                                block: 'center'
                            });
                            firstInvalid.focus();
                        }, 100);
                    }
                });
            }
        });
        
        // CSS-in-JS for additional dynamic styling
        const dynamicStyles = `
            /* Additional responsive adjustments */
            @media (min-width: 1600px) {
                .fi-fo-section-content-ctn.grid-layout {
                    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
                }
            }
            
            @media (max-width: 640px) {
                .fi-fo-field-wrp.large-dropdown {
                    flex: 1 1 100%;
                    min-width: 100%;
                }
            }
            
            /* Enhanced focus states for mobile */
            @media (max-width: 768px) {
                .fi-input:focus, .fi-select-input:focus {
                    transform: none;
                    box-shadow: 0 0 0 2px rgba(139, 115, 85, 0.3);
                }
            }
            
            /* Better spacing for sections with many fields */
            .fi-fo-section-content-ctn.auto-layout.dense {
                gap: 16px;
            }
            
            .fi-fo-section-content-ctn.auto-layout.spacious {
                gap: 32px;
            }
        `;
        
        // Inject dynamic styles
        const styleSheet = document.createElement('style');
        styleSheet.textContent = dynamicStyles;
        document.head.appendChild(styleSheet);
    </script>
</x-filament-panels::page>