<x-filament-panels::page>
    <x-filament-panels::header>
        <h1 class="filament-header-heading">
            View Deposit
        </h1>

        <x-slot name="actions">
            {{ $this->getHeaderActions() }}
        </x-slot>
    </x-filament-panels::header>

    <x-filament-panels::section title="Deposit Details">
        <x-filament-panels::grid columns="2">
            <x-filament-panels::grid.column>
                <x-filament-panels::field label="Client Name">
                    {{ $this->record->client->user->name ?? 'N/A' }}
                </x-filament-panels::field>
            </x-filament-panels::grid.column>

            <x-filament-panels::grid.column>
                <x-filament-panels::field label="Payment Type">
                    {{ str_replace('App\\Models\\', '', $this->record->payable_type) }}
                </x-filament-panels::field>
            </x-filament-panels::grid.column>

            <x-filament-panels::grid.column>
                <x-filament-panels::field label="Related Entity">
                    @if ($this->record->payable_type === 'App\Models\Project')
                        <a href="{{ \App\Filament\Resources\ProjectResource::getUrl('view', ['record' => $this->record->payable_id]) }}" target="_blank">
                            {{ $this->record->payable->name ?? $this->record->payable_id }}
                        </a>
                    @elseif ($this->record->payable_type === 'App\Models\Conveyancing')
                        Conveyancing #{{ $this->record->payable_id }}
                    @elseif ($this->record->payable_type === 'App\Models\Litigation')
                        {{ $this->record->payable->case_number ?? 'Litigation #' . $this->record->payable_id }}
                    @else
                        {{ $this->record->payable_id }}
                    @endif
                </x-filament-panels::field>
            </x-filament-panels::grid.column>

            <x-filament-panels::grid.column>
                <x-filament-panels::field label="Amount">
                    {{ number_format($this->record->amount, 2) }} KES
                </x-filament-panels::field>
            </x-filament-panels::grid.column>

            <x-filament-panels::grid.column>
                <x-filament-panels::field label="Payment Method">
                    {{ ucfirst($this->record->payment_method) }}
                </x-filament-panels::field>
            </x-filament-panels::grid.column>

            <x-filament-panels::grid.column>
                <x-filament-panels::field label="Transaction ID">
                    {{ $this->record->transaction_id ?? 'N/A' }}
                </x-filament-panels::field>
            </x-filament-panels::grid.column>

            <x-filament-panels::grid.column>
                <x-filament-panels::field label="Status">
                    <x-filament-panels::badge :color="match ($this->record->status) {
                        'pending' => 'warning',
                        'completed' => 'success',
                        'failed' => 'danger',
                        default => 'secondary'
                    }">
                        {{ ucfirst($this->record->status) }}
                    </x-filament-panels::badge>
                </x-filament-panels::field>
            </x-filament-panels::grid.column>

            <x-filament-panels::grid.column>
                <x-filament-panels::field label="Created At">
                    {{ $this->record->created_at->format('d M Y H:i') }}
                </x-filament-panels::field>
            </x-filament-panels::grid.column>
        </x-filament-panels::grid>
    </x-filament-panels::section>
</x-filament-panels::page>