<x-filament::page>
    <div 
        x-data="{ showStats: false }"
        class="space-y-4"
    >
        <!-- Toggle Button -->
        <button
            @click="showStats = !showStats"
            class="px-4 py-2 bg-blue-600 border border-blue-600 text-black font-semibold rounded-lg shadow-md hover:bg-blue-700 hover:border-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition"
        >
            <span x-show="showStats">Hide Statistics</span>
            <span x-show="!showStats">Show Statistics</span>
        </button>

        <!-- Stats Widgets -->
        <div x-show="showStats" class="space-y-4">
            @livewire(\App\Filament\Resources\AdminResource\Widgets\PaymentStats::class)
            @livewire(\App\Filament\Resources\AdminResource\Widgets\ProjectStats::class)
        </div>
    </div>
</x-filament::page>
