<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Client;
use App\Models\Advocate;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Faker\Factory as Faker;

class UsersSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();
        //Create Super Admin User
        $superAdmin = User::create([
            "name" => "Super Admin",
            "email" => "su@gmail.com",
            "password" => Hash::make("password")
        ]);
        $superAdmin->assignRole("super_admin");
        //verify the users email
        $superAdmin->markEmailAsVerified();


        // Create an Admin User
        $admin = User::create([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
            'password' => bcrypt('password'),  // Set a default password
        ]);
        $admin->assignRole('admin');
        //verify the users email
        $admin->markEmailAsVerified();

        // Create 10  Client Users
        for ($i = 0; $i < 102; $i++) {

            $user = User::create([
                'name' => $faker->name,
                'email' => $faker->unique()->safeEmail,
                'password' => bcrypt('password'), // Same default password
            ]);

            $user->assignRole('client');
            $user->markEmailAsVerified();

            // Create Client User additional fields
            Client::create([
                'user_id' => $user->id,
                'phone' => '07' . $faker->numberBetween(10, 99) . $faker->numberBetween(100000, 999999),
                'national_id' => $faker->unique()->numerify('########'),
                'address' => $faker->address,
            ]);
        }

        // Create an Advocate User
        $advocate = User::create([
            'name' => 'William  Bonac',
            'email' => 'wb@example.com',
            'password' => bcrypt('password'),
        ]);
        $advocate->assignRole('advocate');
        //verify the users email
        $advocate->markEmailAsVerified();
        Advocate::create([
            'user_id' => $advocate->id,
            'license_number' => 'ADVBCE123',
            'specialization' => 'Family Law',
            'phone' => '2541109654',
            'national_id' => '33245710',
            'address' => '23 Bunche,Nairobi',
        ]);


        // Create an Advocate User
        $advocate = User::create([
            'name' => 'Ian Walihe',
            'email' => 'iw@example.com',
            'password' => bcrypt('password'),
        ]);
        $advocate->assignRole('advocate');
        //verify the users email
        $advocate->markEmailAsVerified();
        Advocate::create([
            'user_id' => $advocate->id,
            'license_number' => 'ADV123456',
            'specialization' => 'Land Case',
            'phone' => '254378992002',
            'national_id' => '33245712',
            'address' => '23 Mandare,Nairobi',
        ]);
    }
}
