<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class SubDivisionDetailSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();

        // Get project_clients that belong specifically to the subdivision project (project_id = 2)
        $projectClients = DB::table('project_clients')
            ->where('project_id', 2)
            ->orderBy('id')
            ->get();

        foreach ($projectClients as $projectClient) {
            DB::table('sub_division_details')->insert([
                'project_id'         => $projectClient->project_id, // always 2 here
                'project_client_id'  => $projectClient->id,
                'amount_paid'        => rand(100000, 500000),
                'amount_charged'        => rand(100000, 1000000),
                'balance'            => rand(0, 50000),
                'plot_number'        => $faker->bothify('Plot-###?'),
                'size'               => "40 by 80",// acres/hectares
                'owner2'             => $faker->name,
                'created_at'         => now(),
                'updated_at'         => now(),
            ]);
        }
    }
}

