<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ProjectDocumentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get existing project IDs
        $projectIds = DB::table('projects')->pluck('id');

        if ($projectIds->isEmpty()) {
            $this->command->warn('No projects found. Seed the projects table first.');
            return;
        }

        foreach ($projectIds as $projectId) {
            DB::table('project_documents')->insert([
                'project_id'   => $projectId,
                'name'         => 'Title Deed',
                'file_path'    => 'project-documents/title_deed.pdf',
                'type'         => 'title_deed',
                'created_at'   => Carbon::now(),
                'updated_at'   => Carbon::now(),
            ]);
        }
    }
}

