<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class ProjectClientSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();

        // Fetch existing project and client IDs
        $projectIds = DB::table('projects')->pluck('id')->toArray();
        $clientIds = DB::table('clients')->pluck('id')->toArray();

        // Check if there are enough records
        if (empty($projectIds) || empty($clientIds)) {
            throw new \Exception('Projects or Clients table is empty. Please seed those tables first.');
        }

        for ($i = 0; $i < 102; $i++) {
            // Generate passport_expiry_date only if not null
            $passportExpiryDate = $faker->dateTimeBetween('now', '+5 years');
            $passportExpiryDate = $passportExpiryDate ? $passportExpiryDate->format('Y-m-d') : null;

            DB::table('project_clients')->insert([
                'project_id' => $faker->randomElement($projectIds),
                'client_id' => $faker->randomElement($clientIds),
                'passport_number' => $faker->bothify('??######'),
                'nationality' => $faker->country,
                'passport_expiry_date' => $passportExpiryDate,
                'kra_pin' => $faker->bothify('A#########?'),
                'identification_image' => $faker->imageUrl(640, 480, 'documents', true, 'passport'),
                'created_at' => $faker->dateTimeThisYear(),
                'updated_at' => $faker->dateTimeThisYear(),
            ]);
        }
    }
}