<?php

namespace Database\Seeders;

use App\Models\Client;
use App\Models\Payment;
use App\Models\Project;
use App\Models\ProjectClient;
use App\Models\ProjectClientPayment;
use Faker\Factory as Faker;
use Illuminate\Database\Seeder;

class ProjectClientPaymentSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();

        $projectClients = ProjectClient::with('client')->get();
        $clientIds = Client::pluck('id')->toArray();

        if ($projectClients->isEmpty() || empty($clientIds)) {
            $this->command->warn('Seed project_clients and clients before seeding project payments.');
            return;
        }

        $methods = ['mpesa', 'bank', 'cash'];
        $statuses = ['pending', 'completed', 'failed'];
        $types = ['purchase_price', 'legal_fees'];

        foreach ($projectClients as $projectClient) {
            $numPayments = rand(1, 1);

            for ($i = 0; $i < $numPayments; $i++) {
                $clientId = $faker->randomElement($clientIds);
                $paymentMethod = $faker->randomElement($methods);
                $status = $faker->randomElement($statuses);
                $transactionId = $faker->unique()->uuid;
                $amount = $faker->numberBetween(5000, 40000);
                //$type = $faker->randomElement($types);
                // Create central payment
                $payment = Payment::create([
                    'client_id'      => $clientId,
                    'payable_id'     => $projectClient->id,
                    'payable_type'   => Project::class,
                    'amount_paid'    => $amount,
                    'payment_method' => $paymentMethod,
                    'transaction_id' => $transactionId,
                    'status'         => $status,
                    'direction'      => 'incoming',
                ]);

                // Create project-specific payment
                ProjectClientPayment::create([
                    'project_client_id' => $projectClient->id,
                    'amount_paid'       => $amount,
                    'payment_method'    => $paymentMethod,
                    'transaction_id'    => $transactionId,
                    'status'            => $status,
                    //'type'              => $type,
                    'payment_id'        => $payment->id,
                ]);
            }
        }
    }
}
