<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ProjectClientDocumentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all project client IDs
        $projectClientIds = DB::table('project_clients')->pluck('id');

        if ($projectClientIds->isEmpty()) {
            $this->command->warn('No project clients found. Seed the project_clients table first.');
            return;
        }

        foreach ($projectClientIds as $projectClientId) {
            DB::table('project_client_documents')->insert([
                'project_client_id' => $projectClientId,
                'name'              => 'Title Deed',
                'file_path'         => 'project-client-documents/title_deed.pdf',
                'type'              => 'title_deed',
                'created_at'        => Carbon::now(),
                'updated_at'        => Carbon::now(),
            ]);
        }
    }

}

