<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Define permissions
        $permissions = [
            'create-role',
            'view-role',
            'edit-role',
            'delete-role',
            'create-user',
            'view-user',
            'edit-user',
            'delete-user',
            'create-case',
            'view-case',
            'edit-case',
            'delete-case',
            'create-document',
            'view-document',
            'edit-document',
            'delete-document',
            'create-payment',
            'edit-payment',
            'delete-payment',
            'view-fund',
            'create-fund',
            'edit-fund',
            'delete-fund',
            'view-legal_advice',
            'create-legal_advice',
            'edit-legal_advice',
            'delete-legal_advice',
        ];

        // Create permissions
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }
    }
}
