<?php
// database/seeders/PaymentSeeder.php

namespace Database\Seeders;

use App\Models\Payment;
use App\Models\Client;
use App\Models\Conveyancing;
use App\Models\Litigation;
use App\Models\Project;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class PaymentSeeder extends Seeder
{
    public function run(): void
    {
        $clients = Client::inRandomOrder()->limit(20)->pluck('id');

        $payables = [
            ['model' => Conveyancing::class, 'count' => 10],
            ['model' => Litigation::class, 'count' => 10],
            ['model' => Project::class, 'count' => 10],
        ];

        foreach ($payables as $payable) {
            $instances = $payable['model']::inRandomOrder()->limit($payable['count'])->get();

            foreach ($instances as $instance) {
                Payment::create([
                    'client_id' => $clients->random(),
                    'payable_type' => $payable['model'],
                    'payable_id' => $instance->id,
                    'amount_paid' => rand(50000, 200000),
                    'payment_method' => collect(['mpesa', 'bank', 'cash'])->random(),
                    'transaction_id' => Str::upper(Str::random(10)),
                    'status' => collect(['pending', 'completed', 'failed'])->random(),
                    'direction' => collect(['incoming', 'outgoing'])->random(),
                ]);
            }
        }
    }
}
