<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;
use App\Models\Litigation;
use App\Models\Client;
use App\Models\Payment;

class LitigationPaymentSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();

        $paymentMethods = ['mpesa', 'bank', 'cash'];
        $statuses = ['pending', 'completed', 'failed'];
        $types = ['legal_fees', 'filing_fees', 'other'];

        $litigations = Litigation::with('client')->get();

        if ($litigations->isEmpty()) {
            $this->command->warn('No litigations found. Seeder skipped.');
            return;
        }

        foreach (range(1, 10) as $i) {
            $litigation = $litigations->random();
            $amount = $faker->numberBetween(5000, 500000);
            $clientId = $litigation->client_id;
            $paymentMethod = $faker->randomElement($paymentMethods);
            $transactionId = $faker->unique()->uuid;
            $status = $faker->randomElement($statuses);
            $type = $faker->randomElement($types);

            // Create polyorphic payment
            $payment = Payment::create([
                'client_id'      => $clientId,
                'payable_id'     => $litigation->id,
                'payable_type'   => Litigation::class,
                'amount_paid'    => $amount,
                'payment_method' => $paymentMethod,
                'transaction_id' => $transactionId,
                'status'         => "completed",
                'direction'      => 'incoming',
               
            ]);

            // Link to litigation_payments
            DB::table('litigation_payments')->insert([
                'litigation_id'   => $litigation->id,
                'client_id'       => $clientId,
                'amount_paid'     => $amount,
                'payment_method'  => $paymentMethod,
                'transaction_id'  => $transactionId,
                'status'          => "completed",
                'type'            => $type,
                'payment_id'      => $payment->id,
                'created_at'      => now(),
                'updated_at'      => now(),
            ]);
        }
    }
}
