<?php

namespace Database\Seeders;

use App\Models\Litigation;
use App\Models\LitigationExpense;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class LitigationExpenseSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();

        $litigationIds = Litigation::pluck('id')->all();

        // Safety check
        if (empty($litigationIds)) {
            $this->command->warn('No litigations found. Seed some litigations first.');
            return;
        }

        
        $titles = [
            'Filing Court Documents',
            'Client Meeting',
            'Travel to Court',
            'Court Fee Payment',
            'Stationery Purchase',
            'Research',
            'Consultation Fee',
            'Service of Process',
            'Photocopying',
            'Phone Call Charges',
        ];

        //types of fees
        $types = [
            'filing_fees',
            'transport',
            'consultation',
            'court_fees',
            'stationery',
            'other',
        ];

        foreach (range(1, 20) as $i) {
            LitigationExpense::create([
                'litigation_id' => $faker->randomElement($litigationIds),
                'title' => $faker->randomElement($titles),
                'amount' => $faker->numberBetween(500, 10000),
                'type' => $faker->randomElement($types),
            ]);
        }
    }
}
