<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Litigation;
use Faker\Factory as Faker;

class LitigationDocumentSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();
        $types = ['pleading', 'evidence', 'correspondence', 'other'];

        // Define 10 unique document titles
        $uniqueTitles = collect(range(1, 10))->map(fn($i) => "Litigation Document $i")->shuffle();

        // Fetch all litigation IDs
        $litigationIds = Litigation::pluck('id');

        // Tracker for used titles
        $usedTitleIndex = 0;

        foreach ($litigationIds as $litigationId) {
            // Stop if all 10 unique titles are used
            if ($usedTitleIndex >= $uniqueTitles->count()) {
                break;
            }

            // Random number of documents for this litigation (1 to 3), but cap at remaining titles
            $remainingTitles = $uniqueTitles->count() - $usedTitleIndex;
            $numDocs = min(rand(1, 3), $remainingTitles);

            for ($i = 0; $i < $numDocs; $i++) {
                DB::table('litigation_documents')->insert([
                    'litigation_id' => $litigationId,
                    'name' => $uniqueTitles[$usedTitleIndex],
                    'file_path' => 'litigation/' . $faker->uuid . '.pdf',
                    'type' => $types[array_rand($types)],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                $usedTitleIndex++;
            }
        }
    }
}
