<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Litigation;
use Illuminate\Support\Str;

class LitigationAdvocateSeeder extends Seeder
{
    public function run(): void
    {
        $litigationIds = Litigation::pluck('id');
        $partyTypes = ['1st Plaintiff', '1st Defendant', '2nd Defendant'];
        $genders = ['Male', 'Female', 'Other'];

        foreach ($litigationIds as $litigationId) {
            // Create 1–3 parties per litigation
            $selectedPartyTypes = collect($partyTypes)->shuffle()->take(rand(1, 3));

            foreach ($selectedPartyTypes as $partyType) {
                DB::table('litigation_advocates')->insert([
                    'litigation_id' => $litigationId,
                    'party' => fake()->name(),
                    'party_type' => $partyType,
                    'email' => fake()->unique()->safeEmail(),
                    'phone' => fake()->phoneNumber(),
                    'gender' => $genders[array_rand($genders)],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
