<?php

namespace Database\Seeders;

use App\Models\Litigation;
use App\Models\LitigationActivity;
use Illuminate\Database\Seeder;

class LitigationActivitySeeder extends Seeder
{
    public function run(): void
    {
        $litigationIds = Litigation::inRandomOrder()->limit(10)->pluck('id');

        // Realistic activity types and outcomes
        $activities = [
            'Mention',
            'Hearing',
            'Ruling',
            'Judgment',
            'Status Conference',
            'Pre-Trial',
            'Directions',
            'Notice of Motion',
            'Cross Examination',
            'Final Submissions'
        ];

        $outcomes = [
            'Adjourned to a later date',
            'Matter heard and concluded',
            'Ruling delivered',
            'Judgment entered for the plaintiff',
            'Judgment entered for the defendant',
            'Interim orders issued',
            'Matter dismissed for non-attendance',
            'Plea taken and hearing scheduled',
            'Hearing conducted and closed',
            'Case withdrawn by parties',
        ];

        foreach ($litigationIds as $id) {
            LitigationActivity::create([
                'litigation_id' => $id,
                'activity' => $activities[array_rand($activities)],
                'court_room' => 'Court Room ' . rand(1, 5),
                'outcome' => $outcomes[array_rand($outcomes)],
                'activity_date' => now()->subDays(rand(5, 120))->format('Y-m-d'),
            ]);
        }
    }
}
