<?php

namespace Database\Seeders;

use App\Models\Invoice;
use App\Models\Client;
use App\Models\Project;
use App\Models\Litigation;
use App\Models\Conveyancing;
use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use Illuminate\Support\Carbon;

class InvoiceSeeder extends Seeder
{
    public function run(): void
    {
        $clients = Client::inRandomOrder()->take(10)->get();
        $payables = collect([
            Project::inRandomOrder()->take(5)->get(),
            Litigation::inRandomOrder()->take(5)->get(),
            Conveyancing::inRandomOrder()->take(5)->get(),
        ])->flatten();

        foreach (range(1, 10) as $i) {
            $payable = $payables->random();
            Invoice::create([
                'client_id'     => $clients->random()->id,
                'payable_type'  => get_class($payable),
                'payable_id'    => $payable->id,
                'issue_date'    => Carbon::now()->subDays(rand(0, 30)),
                'due_date'      => Carbon::now()->addDays(rand(5, 30)),
                'status'        => Arr::random(['unpaid', 'paid', 'overdue']),
                'total_amount'  => rand(5000, 50000),
                'notes'         => 'Generated for testing purposes',
            ]);
        }
    }
}


