<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        
        $this->call([
            RolesSeeder::class, // Seeder for roles
            UsersSeeder::class, // Seeder for users

            //Project Seeder files
            ProjectSeeder::class,//seeder for projects
            ProjectClientSeeder::class,//seeder for project client
            ProjectDocumentSeeder::class,//seeder for project documents
            ProjectClientDocumentSeeder::class,//seeder for project clients
            ProjectClientPaymentSeeder::class,//seeder for project payments
          
            //Apartment and subdivision seeders
            ApartmentDetailSeeder::class,//seeder for apartment details
            SubdivisionDetailSeeder::class,//seeder for subdivision details
            
            //Litigation Seeders
            LitigationSeeder::class,//seeder for litigation
            LitigationAdvocateSeeder::class,//seeder for litigation advocate
            LitigationActivitySeeder::class,//seeder for litigation stage
            LitigationDocumentSeeder::class,//seeders for litigation documents
            //LitigationExpenseSeeder::class,
            //LitigationPaymentSeeder::class,//seeder for litigation payment

            //Conveyancing seeders
            ConveyancingSeeder::class,//seeder for conveyancings
            ConveyancingAdvocateSeeder::class,//seeder for conveyancing advocates
            ConveyancingDocumentSeeder::class,//seeder for conveyancing documents
            //ConveyancingExpenseSeeder::class,//seeder for conveyancing expense  
            //ConveyancingPaymentSeeder::class,//seeder for ceonveyancing payments
          
            //Seeder for invoices
            InvoiceSeeder::class,//seeder for invoices
            
        ]);
    }
}
