<?php

namespace Database\Seeders;

use App\Models\Client;
use App\Models\Conveyancing;
use App\Models\ConveyancingPayment;
use App\Models\Payment;
use Faker\Factory as Faker;
use Illuminate\Database\Seeder;

class ConveyancingPaymentSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();
        $conveyancings = Conveyancing::with('client')->get();
        $clientIds = Client::pluck('id')->toArray();

        if ($conveyancings->isEmpty() || empty($clientIds)) {
            $this->command->warn('Seed conveyancings and clients before seeding payments.');
            return;
        }

        $methods = ['mpesa', 'bank', 'cash'];
        //$statuses = ['pending', 'completed', 'failed'];
        $types = ['purchase_price', 'legal_fees'];

        foreach ($conveyancings as $conveyancing) {
            $numPayments = rand(2, 4);

            for ($i = 0; $i < $numPayments; $i++) {
                $clientId = $faker->randomElement($clientIds);
                $paymentMethod = $faker->randomElement($methods);
                //$status = $faker->randomElement($statuses);
                $transactionId = $faker->unique()->uuid;
                $amount = $faker->numberBetween(5000, 40000);

                // Create central payment record
                $payment = Payment::create([
                    'client_id'      => $clientId,
                    'payable_id'     => $conveyancing->id,
                    'payable_type'   => Conveyancing::class,
                    'amount_paid'    => $amount,
                    'payment_method' => $paymentMethod,
                    'transaction_id' => $transactionId,
                    'status'         => "completed",
                    'direction'      => 'incoming',
                ]);

                // Create conveyancing-specific payment
                ConveyancingPayment::create([
                    'conveyancing_id' => $conveyancing->id,
                    'client_id'       => $clientId,
                    'amount_paid'     => $amount,
                    'payment_method'  => $paymentMethod,
                    'transaction_id'  => $transactionId,
                    'status'          => "completed",
                    'type'            => $faker->randomElement($types),
                    'payment_id'      => $payment->id,
                ]);
            }
        }
    }
}
