<?php

namespace Database\Seeders;

use App\Models\Conveyancing;
use App\Models\ConveyancingExpense;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class ConveyancingExpenseSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();
        $types = ['filing', 'logistics', 'legal_fee', 'registration', 'duty'];

        $conveyancingIds = Conveyancing::pluck('id')->toArray();

        if (empty($conveyancingIds)) {
            return;
        }

        foreach (range(1, 10) as $i) {
            ConveyancingExpense::create([
                'conveyancing_id' => $faker->randomElement($conveyancingIds),
                'type' => $faker->randomElement($types),
                'amount' => $faker->randomFloat(2, 5000, 30000),
            ]);
        }
    }
}
