<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Conveyancing;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class ConveyancingDocumentSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();

        $conveyancingIds = Conveyancing::pluck('id')->toArray();

        if (empty($conveyancingIds)) {
            $this->command->warn('No conveyancing records found. Please seed conveyancing first.');
            return;
        }


        for ($i = 0; $i < 10; $i++) {
            DB::table('conveyancing_documents')->insert([
                'conveyancing_id' => $faker->randomElement($conveyancingIds),
                'name' => 'Document Title ' . $i,
                'file_path' => 'documents/' . $faker->uuid . '.pdf',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
