<?php

namespace Database\Seeders;

use App\Models\Advocate;
use App\Models\Conveyancing;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConveyancingAdvocateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $conveyancingIds = Conveyancing::pluck('id');
        $advocateIds = Advocate::pluck('id');

        $roles = ['Lead', 'Assistant'];

        foreach ($conveyancingIds as $conveyancingId) {
            // Assign 1–2 advocates to each litigation
            $assignedAdvocates = $advocateIds->random(rand(1, min(2, $advocateIds->count())));

            foreach ($assignedAdvocates as $advocateId) {
                DB::table('conveyancing_advocate')->insertOrIgnore([
                    'conveyancing_id' => $conveyancingId,
                    'advocate_id' => $advocateId,
                    'role' => $roles[array_rand($roles)],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
