<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class ApartmentDetailSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();

        // Get first 10 project_clients that belong to the apartment project (project_id = 1)
        $projectClients = DB::table('project_clients')
            ->where('project_id', 1)
            ->orderBy('id')
            ->get();

        $floorNumber = 1;
        $letterIndex = 0;
        $letters = ['A', 'B', 'C', 'D'];

        foreach ($projectClients as $projectClient) {
            $flatName = $floorNumber . $letters[$letterIndex];

            // Move to next letter
            $letterIndex++;

            // After D, move to next floor number and reset letter
            if ($letterIndex >= count($letters)) {
                $letterIndex = 0;
                $floorNumber++;
            }

            DB::table('apartment_details')->insert([
                'project_id'         => $projectClient->project_id,
                'project_client_id'  => $projectClient->id,
                'amount_paid'        => rand(100000, 500000),
                'amount_charged'     => rand(100000, 1000000),
                'balance'            => rand(0, 50000),
                'floor'              => $faker->randomElement(['Ground', '1st', '2nd', '3rd', '4th', '5th']),
                'flat_name'          => $flatName,
                'owner2'             => $faker->name,
                'unit_type'          => $faker->randomElement(['1-bedroom', '2-bedroom', '3-bedroom']),
                'created_at'         => now(),
                'updated_at'         => now(),
            ]);
        }
    }
}

