<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('documents', function (Blueprint $table) {
            $table->id();
            $table->nullableMorphs('documentable'); // Adds documentable_id and documentable_type
            $table->string('name');
            $table->string('file_path');
            $table->string('serial_number')->nullable()->unique();
             $table->softDeletes();
            $table->timestamps();
           
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('documents');
    }
};