<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->id();
            $table->string('quote_number')->unique()->nullable();
            $table->string('type'); // 'conveyancing', 'project', 'litigation'
            $table->foreignId('client_id')->constrained()->cascadeOnDelete();
            $table->text('details')->nullable(); // Summary of services
            $table->decimal('amount', 12, 2);
            $table->date('quote_date')->default(now());
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotations');
    }
};
