<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            // Foreign key to the clients table
            $table->foreignId('client_id')->constrained()->onDelete('cascade');

            // Polymorphic relation: payable_type + payable_id
            $table->unsignedBigInteger('payable_id');
            $table->string('payable_type');

            // Unique invoice number (auto-generated)
            $table->string('invoice_number')->unique();

            // Status of the invoice (e.g., pending, paid, overdue)
            $table->string('status')->default('pending');

            // Total amount to be paid
            $table->decimal('total_amount', 15, 2)->default(0);

            // Optional notes
            $table->text('notes')->nullable();

            // Timestamps and soft deletes
            $table->timestamps();
            $table->softDeletes();

            // Index for polymorphic relationship
            $table->index(['payable_type', 'payable_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
