<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('office_utilities', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // e.g., "Electricity", "Rent"
            $table->integer('amount'); // Expected utility amount
            $table->string('period')->nullable(); // e.g., "January 2025"
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('office_utilities');
    }
};
