<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('apartment_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->cascadeOnDelete();
            $table->foreignId('project_client_id')->constrained()->cascadeOnDelete();
            $table->string('floor');
            $table->string('flat_name');
            $table->text('description')->nullable();
            $table->string('owner2')->nullable();
            $table->integer('amount_charged')->nullable();
            $table->enum('unit_type', ['1-bedroom', '2-bedroom', '3-bedroom', '4-bedroom']);            
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('apartment_details');
    }
};
