<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conveyancing_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conveyancing_id')->constrained()->cascadeOnDelete();
            $table->foreignId('client_id')->constrained()->cascadeOnDelete();
            $table->integer('amount_paid');
            $table->foreignId('paid_by')->nullable()->constrained('clients')->nullOnDelete(); // 👈 Added this line
            $table->string('type')->nullable();
            $table->foreignId('payment_id')->nullable()->constrained('payments')->onDelete('set null');
            $table->enum('payment_method',['mpesa','bank','cash']);
            $table->string('transaction_id')->nullable()->unique();
            //$table->enum('status',['pending','completed','failed']);
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conveyancing_payments');
    }
};
