<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conveyancing_advocate', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('conveyancing_id');
            $table->unsignedBigInteger('advocate_id');
            $table->string('role')->nullable(); // e.g. Lead, Assistant, etc.
            $table->softDeletes();
            $table->timestamps();
            $table->unique(['conveyancing_id', 'advocate_id']);
            $table->foreign('conveyancing_id')->references('id')->on('conveyancings')->onDelete('cascade');
            $table->foreign('advocate_id')->references('id')->on('advocates')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conveyancing_advocates');
    }
};
